import { PrismaClient } from '@prisma/client'

const prisma = new PrismaClient()

async function main() {
  // Create games
  const deltaForce = await prisma.game.create({
    data: {
      name: 'Delta Force',
      description: 'Tactical first-person shooter game with intense combat scenarios',
      image: '/games/delta-force.jpg',
      slug: 'delta-force',
    },
  })

  const pubgMobile = await prisma.game.create({
    data: {
      name: 'PUBG Mobile',
      description: 'Battle royale game where 100 players fight to be the last one standing',
      image: '/games/pubg-mobile.jpg',
      slug: 'pubg-mobile',
    },
  })

  const mobileLegend = await prisma.game.create({
    data: {
      name: 'Mobile Legend',
      description: 'Multiplayer online battle arena (MOBA) game for mobile devices',
      image: '/games/mobile-legend.jpg',
      slug: 'mobile-legend',
    },
  })

  // Create pricing plans for each game
  const pricingPlans = [
    // Delta Force pricing
    {
      gameId: deltaForce.id,
      duration: '1_day',
      price: 15000,
    },
    {
      gameId: deltaForce.id,
      duration: '1_week',
      price: 75000,
    },
    {
      gameId: deltaForce.id,
      duration: '1_month',
      price: 250000,
    },
    // PUBG Mobile pricing
    {
      gameId: pubgMobile.id,
      duration: '1_day',
      price: 20000,
    },
    {
      gameId: pubgMobile.id,
      duration: '1_week',
      price: 100000,
    },
    {
      gameId: pubgMobile.id,
      duration: '1_month',
      price: 300000,
    },
    // Mobile Legend pricing
    {
      gameId: mobileLegend.id,
      duration: '1_day',
      price: 10000,
    },
    {
      gameId: mobileLegend.id,
      duration: '1_week',
      price: 50000,
    },
    {
      gameId: mobileLegend.id,
      duration: '1_month',
      price: 150000,
    },
  ]

  for (const plan of pricingPlans) {
    await prisma.pricingPlan.create({
      data: plan,
    })
  }

  console.log('Database seeded successfully!')
}

main()
  .catch((e) => {
    console.error(e)
    process.exit(1)
  })
  .finally(async () => {
    await prisma.$disconnect()
  })